 aR  w Q mP9      h	 oP     nSystem-wide$PAGEWIDTH(150)

    NAME CpMemmgr

; This is cp.memmgr.asm~text~
; This contains all the memory manager routines

$NOLIST
$INCLUDE (``OsIncs`CpConst~Inc~)

DGROUP GROUP DATA
CGROUP GROUP CODE
;SYSDEP_DGROUP GROUP SYSDEP_DATA

    PUBLIC CpFree, CpGetSize, InitMemMgr
    PUBLIC IntAllocate, SmartIntAllocate, CpAllocate, CpFreeTaskMem
    PUBLIC CpGetMemStatus, AddOsCGrpBlkToMemory
    
    PUBLIC WaitOnDosSemaGiveMem, TakeMemSignalDosSema


    EXTRN OsVerifyCheckSum:FAR, OsRemoveFromQ:FAR, OsInsertIntoQ:FAR
    EXTRN OsInitQcb:FAR, OsElementCheckSum:FAR, OsElementInQ:FAR
    EXTRN CpWait:FAR, CpSignal:FAR, CpCreateSemaphore:FAR
    EXTRN LQ_DWORD_MUL:FAR
    EXTRN Exception:FAR

    EXTRN CpSetActiveSlot:FAR, ExitProgram:FAR
    EXTRN WaitOnMsDosSema:FAR, SignalMsDosSema:FAR

    EXTRN osCurrentPid:WORD  ; current process ID


; constants

bytesPerBlk EQU 16         ; bytes per memory control block


; variables

DATA SEGMENT PUBLIC 'DATA'


dummyError  DW ?             ; dummy error location


startMemory DW ?             ; beginning of last allocated MsDos block
lenOfMemory DW ?             ; length of last allocated block (in paragraphs)
endOfMemory DW ?             ; end of usable memory (and last block)
lastFreeBlk DW ?             ; address of block that was given to MsDos

; These are in CpTask.Asm

EXTRN osFreeMemQ: BYTE       ; Free memory list
EXTRN osAllocMemQ: BYTE      ; Allocate memory list

; This is in Rom.Asm

EXTRN romsExecute: BYTE      ; GRiD Roms execute in 512-640k area flag

; These are in ScrIntfc.Asm

EXTRN osCGrpAddr: WORD
EXTRN osCGrpSize: WORD

;SYSDEP_DATA SEGMENT PUBLIC 'DATA'

EXTRN msDosSema: WORD

;SYSDEP_DATA ENDS

DATA ENDS



; This must be on a paragraph boundary

;MemMgrSemaphore SEGMENT PARA 'DATA'
;
;MemMgrScb ScbType <>         ; Memory manager semaphore
;
;MemMgrSemaphore ENDS


CODE SEGMENT BYTE PUBLIC 'CODE'
     ASSUME CS:CGROUP, DS:DGROUP


DataFrame DW DATA            ; segment of data group
$EJECT

;    AddOsCGrpBlkToMemory: PROCEDURE CLEAN;
;
;    This will add the memory block freed up by putting OS_CGROUP into EMS
;
AddOsCGrpBlkToMemory PROC FAR
    PUSH DS
    MOV  DS, CS:DataFrame

    MOV  AX, osCGrpAddr
    OR   AX, AX
    JZ   AddOsCGrpExit

    MOV  BX, osCGrpSize
    DEC  BX
    MOV  DS, AX                      ; DS ^ new free segment
    MOV  DS:mmcbNumBlk, BX           ; initScb.numBlk := numBlk - 1
    MOV  DS:mmcbRemainder, 0         ; initScb.remainder := 0

    PUSH DS
    CALL AddToFreeChain              ; Add this block to the free chain

AddOsCGrpExit:
    POP  DS
    RET
AddOsCGrpBlkToMemory ENDP
$EJECT

;    InitMemMgr: PROCEDURE CLEAN;
;
;    This will initialize the memory manager
;    but leave all of the queues empty

InitMemMgr PROC FAR
    PUSH DS


    MOV  AL, 0FFH
    PUSH AX
    CALL CpSetActiveSlot             ; Return current slot

    PUSH AX                          ; Save current slot

    OR   AL, 80H
    PUSH AX
    CALL CpSetActiveSlot             ; Turn off ROMs


    CALL AtOsAllocMemQ               ; @OsAllocMemQ
    
;;;    MOV  AL, TRUE
    MOV  AL, FALSE
    PUSH AX                          ; FALSE
    
    MOV  AX, SIZE MemCbType
    PUSH AX                          ; size of a memory control block

    CALL OsInitQcb


    CALL AtOsFreeMemQ                ; @OsFreeMemQ
    
;;;    MOV  AL, TRUE
    MOV  AL, FALSE
    PUSH AX                          ; FALSE
    
    MOV  AX, SIZE MemCbType
    PUSH AX                          ; size of a memory control block

    CALL OsInitQcb


;   MOV  AX, SYSDEP_DGROUP           ; Initialize msDosSema to be invalid
    MOV  AX, DGROUP                  ; Initialize msDosSema to be invalid
    MOV  DS, AX                      ; until it is initialized by the
    MOV  DS:msDosSema, 0             ; system dependant code

    CALL AddBiggestMsDosMemBlk
    OR   AX, AX                      ; If no error then done
    JZ   InitMemMgrDone

    PUSH AX                          ; error
    XOR  AX, AX
    PUSH AX
    PUSH AX                          ; pMsg = 0 for early exit, out of mem
    CALL ExitProgram                 ; CALL ExitProgram (error, 0);

InitMemMgrDone:
   ;POP  AX                          ; Get back the current slot
   ;PUSH AX                          ; Push it as a parm to CpSetActiveSlot
    CALL CpSetActiveSlot             ; Turn current ROM back on

    POP  DS
    RET
InitMemMgr ENDP
$EJECT

;
;    WaitOnDosSemaGiveMem: PROCEDURE WORD CLEAN;
;
;  This routine will lock out users from the Memory manager and give
;  the last free block to MsDos

;  This returns an error indicating if the request was successful (or not)

WaitOnDosSemaGiveMem PROC FAR
    PUSH DS
    MOV  DS, CS:DataFrame

    CALL WaitOnMsDosSema             ; Lock out other memory requests

    MOV  BX, OFFSET osFreeMemQ       ; Get last free memory block
    MOV  ES, DS:[BX].tailOfQ
    MOV  AX, ES

    ADD  AX, ES:mmcbNumBlk           ; Verify that it really is the last block
    INC  AX
    CMP  AX, endOfMemory             ; If not last block
    MOV  AX, eOutOfMem               ; then RETURN (eOutOfMem)
    JNE  GiveMsDosMemRet

    PUSH ES                          ; Save addr of last free block

    CALL AtOsFreeMemQ
    PUSH ES                          ; CALL OsRemoveFromQ
    CALL OsRemoveFromQ               ;  (@osFreeMemQ, sLastBlk)

    POP  BX                          ; Last free block
    MOV  lastFreeBlk, BX
    MOV  AX, startMemory
    SUB  BX, AX                      ; Determine new length of mem pool

    MOV  ES, AX                      ; Give memory back to MsDos
    MOV  AH, 4AH
    INT  21H
    JC   GiveMsDosMemRet             ; RETURN (error)

    XOR  AX, AX                      ; RETURN (eOK)

GiveMsDosMemRet:
    POP  DS
    RET
WaitOnDosSemaGiveMem ENDP
$EJECT

;
;    TakeMemSignalDosSema: PROCEDURE WORD CLEAN;
;
;  This routine expands the last free block of memory or
;  allocates the next largest MsDos block of memory and
;  give users access back to the Memory manager.

;  This returns an error indicating if the request was successful (or not)

TakeMemSignalDosSema PROC FAR
    PUSH DS
    MOV  DS, CS:DataFrame

    MOV  ES, startMemory
    MOV  BX, lenOfMemory
    MOV  AH, 4AH                     ; Grow memory to original size
    INT  21H
    JC   TakeMsDosMemFragmented

    MOV  AX, lastFreeBlk
    MOV  BX, endOfMemory
    SUB  BX, AX
    DEC  BX                          ; numBlks = end - lastBlk - 1
    MOV  DS, AX                      ; DS ^ new free segment
    MOV  DS:mmcbNumBlk, BX           ; initScb.numBlk := numBlk - 1
    MOV  DS:mmcbRemainder, 0         ; initScb.remainder := 0

    PUSH DS
    CALL AddToFreeChain              ; Add this block to the free chain
    XOR  AX, AX                      ; RETURN (eOK)
    JMP  SHORT TakeMsDosMemDone

TakeMsDosMemFragmented:
    CALL AddBiggestMsDosMemBlk       ; This routine returns error

TakeMsDosMemDone:
    PUSH AX                          ; Save error
    CALL SignalMsDosSema
    POP  AX                          ; Restore error

    POP  DS
    RET
TakeMemSignalDosSema ENDP
$EJECT

;    AddBiggestMsDosMemBlk

; ROMs must be off if this routine is to be called
; The only routines calling this routine now are
; InitMemMgr and TakeMemSignalDosSema

; Exit
;  AX = error
;  ES, DS amongst others are changed

AddBiggestMsDosMemBlk PROC NEAR
    MOV  BX, 0FFFFH
    MOV  AH, 48H                     ; This should return an error
    INT  21H                         ; with BX = actual amt memory available

    MOV  AH, 48H                     ; Allocate all of memory
    INT  21H
    JC   AddBiggestBlkRet            ; RETURN (error)

    MOV  CX, DGROUP
    MOV  DS, CX                      ; Set up data segment

    MOV  CX, AX
    ADD  CX, BX                      ; CX = End of memory (+1)

    TEST DS:romsExecute, 1           ; If there are no GRiD Roms
    JZ   InitMemoryHere              ; then no changes needed

    CMP  CX, 8000H                   ; If memory is 512K or less
    JBE  InitMemoryHere              ; then no changes needed

    SUB  CX, 8000H                   ; Subtract difference over 512K
    SUB  BX, CX                      ; from original memory block

    MOV  ES, AX
    MOV  AH, 4AH                     ; Shrink memory block to this size
    INT  21H
    JC   AddBiggestBlkRet            ; RETURN (error)

    MOV  AX, ES
    MOV  CX, 8000H

    CMP  AX, CX                      ; If beginning of block is before
    JB   InitMemoryHere              ; Rom boundary end then its okay

    MOV  AX, eOutOfMem               ; If beginning of block is after
    JMP  SHORT AddBiggestBlkRet      ; Rom boundary then RETURN (eOutOfMem)

InitMemoryHere:
    MOV  DS:startMemory, AX
    MOV  DS:lenOfMemory, BX
    MOV  DS:endOfMemory, CX

    MOV  DS, AX                      ; DS ^ initial free segment

    DEC  BX
    MOV  DS:mmcbNumBlk, BX           ; initScb.numBlk := numBlk - 1
    MOV  DS:mmcbRemainder, 0         ; initScb.remainder := 0

    PUSH DS
    CALL AddToFreeChain              ; Add this block to the free chain
    XOR  AX, AX                      ; RETURN (eOK)

AddBiggestBlkRet:
    RET
AddBiggestMsDosMemBlk ENDP
$EJECT

;    EnterMemMgr: PROCEDURE;
;
;    This will just wait on the memory manager semaphore

EnterMemMgr PROC NEAR

;    MOV  AX, SEG MemmgrScb
;    PUSH AX                        ; semaphoreId

;   MOV  AX, SYSDEP_DGROUP
    MOV  AX, DGROUP
    MOV  ES, AX
    MOV  AX, ES:msDosSema          ; If msDosSema does not exist
    OR   AX, AX                    ; yet, then
    JZ   EnterMemMgrRet            ; Return

    PUSH AX                        ; semaphore ID

    MOV  AX, nullWord
    PUSH AX                        ; wait forever

    PUSH CS:DataFrame
    MOV  AX, OFFSET dummyError     ; @dummyerror
    PUSH AX

    CALL CpWait

EnterMemMgrRet:
    RET
EnterMemMgr ENDP


;    LeaveMemMgr: PROCEDURE
;
;    This will signal the memory manager semaphore

LeaveMemMgr PROC NEAR

;    MOV  AX, SEG MemmgrScb
;    PUSH AX                        ; semaphoreId

;   MOV  AX, SYSDEP_DGROUP
    MOV  AX, DGROUP
    MOV  ES, AX
    MOV  AX, ES:msDosSema          ; If msDosSema does not exist
    OR   AX, AX                    ; yet, then
    JZ   LeaveMemMgrRet            ; Return

    PUSH AX                        ; semaphore ID

    MOV  AX, signalNormal
    PUSH AX                        ; normal signal

    PUSH AX                        ; random note

    PUSH CS:DataFrame
    MOV  AX, OFFSET dummyError     ; @dummyerror
    PUSH AX

    CALL CpSignal

LeaveMemMgrRet:
    RET
LeaveMemMgr ENDP
$EJECT

;    AtOsFreeMemQ
;
;    This will leave the address of OsFreeMemQ on the stack
;    It changes AX and DI

AtOsFreeMemQ PROC NEAR
    POP  DI                        ; save return address

    PUSH CS:DataFrame              ; push segment
    MOV  AX, OFFSET osFreeMemQ
    PUSH AX                        ; push offset

    JMP  DI                        ; return to caller
AtOsFreeMemQ ENDP


;    AtOsAllocMemQ
;
;    This will leave the address of OsAllocMemQ on the stack
;    It changes AX and DI

AtOsAllocMemQ PROC NEAR
    POP  DI                        ; save return address

    PUSH CS:DataFrame              ; push segment
    MOV  AX, OFFSET osAllocMemQ
    PUSH AX                        ; push offset

    JMP  DI                        ; return to caller
AtOsAllocMemQ ENDP
$EJECT

;    CheckCheckSum: PROCEDURE (scbSeg)
;        DCL scbSeg SELECTOR;
;
;    This will verify the checksum of this scbSeg.  If
;    it is okay, then this returns normally.  If it is not
;    okay, than an exception is raised and this never returns.

scbSeg  EQU WORD PTR [BP+4]

CheckCheckSum PROC NEAR
    PUSH BP
    MOV  BP, SP

    CALL AtOsFreeMemQ              ; This assumes Free and Alloc are same size
    PUSH scbSeg                    ; scbSeg
    CALL OsVerifyCheckSum

    RCR AL, 1
    JC CheckDone                   ; IF NOT(OsVerifyCheckSum(@OsFreeMemQ,scbSeg)

; ***** 6/19/85 code optimization
    MOV  AX, memException
    PUSH AX
    MOV  AX, eCheckSum
    PUSH AX
    CALL Exception

CheckDone:
    POP BP
    RET 2
CheckCheckSum ENDP

PURGE scbSeg
$EJECT

;    AddToFreeChain: PROCEDURE (scbSeg)
;        DCL scbSeg SELECTOR;
;
;    This will add an scb to the free queue.  If possible
;    it will coallesce it with already freed scbs.  It will
;    always add to the free queue in order of ascending address

scbSeg    EQU WORD PTR [BP+6]      ; first param

tempSeg   EQU WORD PTR [BP-2]      ; local variable
curScbSeg EQU WORD PTR [BP-4]      ; designated register variable

AddToFreeChain PROC NEAR
    PUSH DS
    PUSH BP                      
    MOV  BP, SP
    SUB  SP, 4                     ; 2 local variables

    MOV  DS, CS:DataFrame
    MOV  AX, DS:OsFreeMemQ.headOfQ ; curScbSeg := OsFreeMemQ.headOfQ
    MOV  curScbSeg, AX             

    MOV  DS, scbSeg
    MOV  DS:mmcbPid, nullWord      ; scb.pid := nullWord;
    MOV  tempSeg, nullWord         ; tempSeq := nullWord;

AddToTopOfLoop:
    CMP  curScbSeg, nullWord       ; DO WHILE curScbSeg <> nullWord;
    JNE  AddTo01
    JMP  AddToLoopExit

AddTo01:
;;;    PUSH curScbSeg                 ;     verify checkSum
;;;    CALL CheckCheckSum

    MOV  AX, curScbSeg
    MOV  ES, AX
    ADD  AX, ES:mmcbNumBlk
    INC  AX                        ;     AX := curScbSeg + curScb.numBlk + 1

    CMP  AX, scbSeg                ;     IF (AX = scbSeg) THEN DO;
    JNE  AddToSecondTest

    MOV  DS, scbSeg
    MOV  AX, DS:mmcbNumBlk
    INC  AX
    ADD  ES:mmcbNumBlk, AX         ;         curScb.numBlk := curScb.numBlk + scb.numBlk + 1;

    MOV  AX, ES
    ADD  AX, ES:mmcbNumBlk
    INC  AX
    CMP  AX, ES:next               ;         IF (curScbSeg + curScb.numBlk + 1) = curScb.next THEN DO;
    JNE  AddTo20

    MOV  DS, ES:next
    MOV  AX, DS:mmcbNumBlk
    INC  AX
    ADD  ES:mmcbNumBlk, AX         ;             curScb.numBlk := curScb.numBlk + nextScb.numBlk + 1;

    CALL AtOsFreeMemQ              ;             @OsFreeMemQ
    PUSH DS                        ;             curScb.next
    CALL OsRemoveFromQ

    JMP  SHORT AddToReturn

AddTo20:                           ;         ELSE
;;;    CALL AtOsFreememQ              ;             @OsFreeMemQ
;;;    PUSH ES                        ;             curScbSeg
;;;    CALL OsElementCheckSum

;;;    MOV  ES, curScbSeg
;;;    MOV  ES:checkSum, AX           ;             curScb := CheckSum(@OsFreeMemQ, curScbSeg)
    JMP  SHORT AddToReturn

AddToSecondTest:
    MOV  DS, scbSeg
    MOV  AX, DS
    ADD  AX, DS:mmcbNumBlk
    INC  AX
    CMP  AX, curScbSeg             ;     IF (scbSeg + scb.numBlk + 1) = curScbSeg THEN DO;
    JNE  AddToThirdTest

    MOV  ES, curScbSeg
    MOV  AX, ES:mmcbNumBlk
    INC  AX
    ADD  DS:mmcbNumBlk, AX         ;         scbSeg.numBlk := scbSeg.numBlk + curScbSeg.numBlk + 1;

    CALL AtOsFreeMemQ              ;         @OsFreeMemQ
    PUSH curScbSeg                 ;         curScbSeg
    CALL OsRemoveFromQ

    CALL AtOsFreeMemQ              ;         @OsFreeMemQ
    PUSH tempSeg                   ;         tempSeg
    PUSH scbSeg                    ;         scbSeg
    CALL OsInsertIntoQ

    JMP  SHORT AddToReturn

AddToThirdTest:
    MOV  AX, curScbSeg
    CMP  AX, scbSeg                 ;     IF curScbSeg > scbSeg THEN GOTO LoopExit;
    JA   AddToLoopExit

    MOV  tempSeg, AX                ;     tempSeg := curScbSeg

    MOV  ES, AX
    MOV  AX, ES:next                ;     curScbSeg := curScb.next
    MOV  curScbSeg, AX
    JMP  AddToTopOfLoop

AddToLoopExit:
    CALL AtOsFreeMemQ              ; @OsFreeMemQ
    PUSH tempSeg                   ; tempSeg
    PUSH scbSeg                    ; scbSeg
    CALL OsInsertIntoQ

AddToReturn:
    MOV  SP, BP
    POP  BP
    POP  DS
    RET  2
AddToFreeChain ENDP

PURGE tempSeg, scbSeg, curScbSeg
$EJECT

;    Allocated: PROCEDURE (scbSeg) BOOLEAN
;        DCL scbSeg SELECTOR;
;
;    This will return TRUE if the segment is in OsAllocMemQ

scbSeg EQU WORD PTR [BP+4]

Allocated PROC NEAR
    PUSH BP
    MOV  BP, SP

    CALL AtOsAllocMemQ             ; @OsAllocmemQ

    PUSH scbSeg                    ; scbSeg

    CALL OsElementInQ

    POP  BP
    RET  2
Allocated ENDP

PURGE scbSeg
$EJECT

;    CpFree: PROCEDURE (pBlock, pError) CLEAN;
;
;    This will free a segment that must have already
;    been allocated.  All this does is retrun the segment
;    to the free queue.

pError EQU DWORD PTR [BP+8]        ; second param
pBlock EQU DWORD PTR [BP+12]       ; first param
pBlockSeg EQU WORD PTR [BP+14]     ; segment of pBlock6

; let DS be the scbSeg

CpFree PROC FAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    CALL EnterMemMgr

    MOV  AX, pBlockSeg
    DEC  AX
    MOV  DS, AX                    ; scbSeg := SELECTOR(pBlock) - 1;

    PUSH DS                        ; scbSeg
    CALL Allocated

    RCR  AL, 1                     ; IF Not Allocated Then
    MOV  AX, eInvMemBlock          ; error = eInvMemBlock
    JNC  OsFreeDone

    CALL AtOsAllocMemQ             ; Push @osAllocMemQ onto stack
    PUSH DS                        ; scbSeg
    CALL OsRemoveFromQ

    PUSH DS                        ; scbSeg
    CALL AddToFreeChain

    XOR  AX, AX                    ; error = eOK

OsFreeDone:
    LES  BX, pError
    MOV  WORD PTR ES:[BX], AX ;     error := eInvMemBlock

    CALL LeaveMemMgr
    POP  BP
    POP  DS
    RET  8
CpFree ENDP

PURGE pError, pBlock, pBlockSeg
$EJECT

;    CpGetSize: PROCEDURE (pBlock, pError) WORD CLEAN;
;
;    This will return the size (in bytes) of an allocated
;    block.  If the block hasn't been allocated, then an error
;    is returned.

pError    EQU DWORD PTR [BP+8]       ; second param
pBlock    EQU DWORD PTR [BP+12]      ; first param
pBlockSeg EQU  WORD PTR [BP+14]      ; segment of pBlock6

; let DS be scbSeg

CpGetSize PROC FAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    CALL EnterMemMgr

    MOV  AX, pBlockSeg
    DEC  AX
    MOV  DS, AX                     ; scbSeg := SELECTOROF(pBlock) - 1;

    PUSH DS                         ; scbSeg
    CALL Allocated

    RCR  AL, 1                      ; IF Allocated(scbSeg) THEN DO;
    JNC  OsGsNotAllocated

    LES  BX, pError
    MOV  WORD PTR ES:[BX], eOK      ;   error := eOK;

    MOV  AX, DS:mmcbNumBlk
    DEC  AX
    MOV  CL, 4                      ;   numBytes := ((scb.numBlk - 1) * 16)
    SHL  AX, CL                     ;     + scb.remainder
    ADD  AX, DS:mmcbRemainder

    CMP  DS:mmcbRemainder, 0
    JNE  OsGsDone                   ;   IF scb.remainder = 0 THEN DO;

    ADD  AX, bytesPerBlk            ;     numBytes := numBytes + bytesPerBlk;
    JMP  SHORT OsGsDone

OsGsNotAllocated:                   ; ELSE DO;
    LES  BX, pError
    MOV  WORD PTR ES:[BX], eInvMemBlock ;  error = einvMemBlock;
    XOR  AX, AX                     ;   numBytes := 0;

OsGsDone:
    PUSH AX
    CALL LeaveMemMgr
    POP  AX                         ; return numBytes in AX

    POP  BP
    POP  DS
    RET  8
CpGetSize ENDP

PURGE pBlock, pBlockSeg, pError
$EJECT

;    For InteGRiD, IntAllocate & SmartIntAllocate are the same.
;    Memory will be allocated from low memory up.

;    IntAllocate: PROCEDURE (pid, size, pError) PTR CLEAN;
;        DCL pid PidType;
;        DCL size WORD;
;        DCL pError PTR;
;
;    This will attempt to allocate a block of size bytes.
;    It will grab the first block that is >= the desired size.
;    Thus it uses a "first fit" algorithm.

; and ...

;    SmartIntAllocate: PROCEDURE (systemAllocate, pid, size, pError) PTR CLEAN;
;        DCL systemAllocate BOOLEAN;
;        DCL pid PidType;
;        DCL size WORD;
;        DCL pError PTR;
;
;    This will attempt to allocate a block of size bytes.
;    It will grab the first block that is >= the desired size.
;    Thus it uses a "first fit" algorithm.

pError    EQU DWORD PTR [BP+8]       ; third param
siz       EQU  WORD PTR	[BP+12]      ; second param
pid       EQU  WORD PTR [BP+14]      ; first param
sysAlloc  EQU  WORD PTR [BP+16]      ; zeroth param 

numBlkReq EQU  WORD PTR [BP-2]       ; local variable
remainder EQU  BYTE PTR [BP-4]       ; local variable
appAlloc  EQU  BYTE PTR [BP-3]       ; use high bit only
systemUse EQU  01                    ; low bit of appAlloc

; let DS be curScbSeg and newScbSeg

SmartIntAllocate PROC FAR
    PUSH DS
    PUSH BP
    MOV  BP, SP
    SUB  SP, 4                       ; 3 local variables

;    MOV  AX, sysAlloc
;    AND  AX, systemUse               ; only keep LSBit

    CALL DoTheAlloc

    MOV  SP, BP
    POP  BP
    POP  DS
    RET  10
SmartIntAllocate ENDP

IntAllocate PROC FAR
    PUSH DS
    PUSH BP
    MOV  BP, SP
    SUB  SP, 4                       ; 3 local variables

;    XOR  AX, AX                      ; assume application alloc

    CALL DoTheAlloc

    MOV  SP, BP
    POP  BP
    POP  DS
    RET  8
IntAllocate ENDP
$EJECT

;
; DoTheAlloc    
;
; Upon Entry: 
;   AX = 0   implies application alloc unles pid = systemPid
;        1   implies system allocation (allocate in low memory)
;
; Upon Exit:
;   pError set
;   ES:[BX] = pMemory

DoTheAlloc PROC NEAR
;    PUSH AX

    CALL EnterMemMgr

    MOV  ES, CS:DataFrame
    MOV  BX, OFFSET OsFreeMemQ

;    POP  AX                         ; original sys alloc value 
;    CMP  AL, systemUse
;    JZ   DoLowMem                   ; IF AL = 1 THEN GOTO DoLowMem
;    CMP  pid, systemPid             ; implies application allocate
;    JNE  IntEnter

DoLowMem:
;    MOV  AL, systemUse              ; system allocate
    MOV  DS, ES:[BX].headOfQ        ; ds := curScbSeg
;    JMP  SHORT IntEnter1

IntEnter:
;    MOV  DS, ES:[BX].tailOfQ         ; ds := curScbSeg

IntEnter1:
;    MOV  appAlloc, AL

    MOV  AX, siz
    DEC  AX
    MOV  CL, 4
    SHR  AX, CL                     ; numBlkReq := ((size - 1) / 16) + 1;
    INC  AX
    MOV  numBlkReq, AX

    MOV  AX, siz
    AND  AX, 0000fh                 ; remainder := size MOD 16;
    MOV  remainder, AL

IntAllTopOfLoop:
    MOV  AX, DS
    CMP  AX, nullWord               ; DO WHILE (curScbSeg <> nullWord);
    JNE  IntAll05
    JMP  IntAllNone

IntAll05:
;;;    PUSH DS                         ;     curScbSeg
;;;    CALL CheckCheckSum              ;     verify checksum

    MOV  AX, DS:mmcbNumBlk
    CMP  AX, numBlkReq              ;     IF curScb.numBlk >= numBlkReq THEN DO;
    JAE  IntAll15
    JMP  IntAllNoRoom

IntAll15:
    DEC  AX
    CMP  AX, numBlkReq              ;         IF (curScb.numBlk - 1) <= 
                                    ;            numBlkReq THEN DO;
    JA   IntAllUsePart

    CALL AtOsFreeMemQ               ;             @OsFreeMemQ
    PUSH DS                         ;             curScbSeg
    CALL OsRemoveFromQ

    JMP  SHORT IntAllFinish         ;             newScbSeg = curScbSeg

IntAllUsePart:                      ;         ELSE DO
;    CMP  appAlloc, systemUse
;    JE   IntAlloc17                 ;           IF systemAllocate THEN
;    JMP  IntAlloc19

IntAlloc17:                         ; 
    CALL AtOsFreeMemQ               ;             @OsFreeMemQ
    PUSH DS                         ;             curScbSeg
    CALL OsRemoveFromQ              ;             OsRemoveFromQ (curScbSeg);

;    PUSH DS                         ;             Save New memory block

    MOV  AX, DS                     ;             curScbSeg := curScbSeg +
    ADD  AX, numBlkReq              ;                numBlkReq + 1;
    INC  AX
    MOV  ES, AX

    MOV  AX, DS:mmcbPid             ;             copy memory block to new spot
    MOV  ES:mmcbPid, AX

    MOV  AX, DS:mmcbRemainder
    MOV  ES:mmcbRemainder, AX

    MOV  AX, DS:mmcbNumBlk          ;             curScbSeg.numBlk := 
    SUB  AX, numBlkReq              ;               curScbSeg.numBlk - numBlk
    DEC  AX                         ;               - 1;
    MOV  ES:mmcbNumBlk, AX

    PUSH ES
    CALL AddToFreeChain             ;             AddToFreeChain (curScbSeg)

;    JMP  IntAllocAlmostDone         ;             END;

;IntAlloc19:                         ;           ELSE DO;
;    MOV  AX, DS
;    ADD  AX, DS:mmcbNumBlk
;    SUB  AX, numBlkReq              ;             AX (newScbSeg) := curscbSeg 
;                                    ;               + curScb.numBlk - ;numBlkReq;
;    PUSH AX                         ;             save newScbSeg
;
;    MOV  AX, numBlkReq
;    INC  AX
;    SUB  DS:mmcbNumBlk, AX          ;             curScb.numBlk := 
;                                    ;              curScb.numBlk - numBlkReq-1
;    CALL AtOsFreeMemQ               ;             @OsFreeMemQ
;    PUSH DS                         ;             curScbSeg
;    CALL OsElementCheckSum
;    MOV  DS:checkSum, AX            ;             curScb.checksum := 
                                    ;               OsElementCheckSum 
                                    ;                 (@OsFreeMemQ, curScbSeg)

IntAllocAlmostDone:                 ;             END;
;    POP  DS                         ;             from previous PUSH AX/PUSH DS

    MOV  AX, numBlkReq
    MOV  DS:mmcbNumBlk, AX          ;             newScb.numBlk := numBlkReq

IntAllFinish:
    MOV  AL, remainder
    XOR  AH, AH
    MOV  DS:mmcbRemainder, AX       ;         newScb.remainder := remainder

    MOV  AX, pid
    MOV  DS:mmcbPid, AX             ;         newScb.pid := pid

;;;    CALL AtOsAllocMemQ              ;         @OsAllocMemQ
;;;    PUSH DS                         ;         newScbSeg
;;;    CALL OsElementCheckSum
;;;    MOV  DS:checkSum, AX            ;         newScb.checkSum := 
                                    ;           OsElementChecksum 
                                    ;             (@OsAllocMemQ, newScbSeg)

    CALL AtOsAllocMemQ              ;         @OsAllocMemQ
    MOV  AX, nullWord
    PUSH AX                         ;         add to front of q
    PUSH DS                         ;         newScbSeg
    CALL OsInsertIntoQ

    LES  BX, pError
    MOV  WORD PTR ES:[BX], eOK      ;         error := eOK

    MOV  AX, DS
    INC  AX
    MOV  ES, AX                     ;         ES:BX := BUILDPTR (newScbSeg + 1,
                                    ;                            0)
    XOR  BX, BX

    JMP  SHORT IntAllDone

IntAllNoRoom:
;    CMP  appAlloc, systemUse
;    JNE  IntAll20

    MOV  DS, DS:next
    JMP  IntAllTopOfLoop

;IntAll20:
;    MOV  DS, DS:prev                ;     Try previous element
;    JMP  IntAllTopOfLoop

IntAllNone:
    LDS  BX, pError
    MOV  WORD PTR DS:[BX], eOutOfMem;         error := eOK

    MOV  AX, nullWord
    MOV  ES, AX                     ; no memory, return nullPtr
    MOV  BX, 0000fh

IntAllDone:
    PUSH ES
    PUSH BX
    CALL LeaveMemMgr                ; save result, leave memmgr, restore result
    POP  BX
    POP  ES
    RET
DoTheAlloc ENDP

PURGE sysAlloc, pError, siz, pid, numBlkReq, remainder, appAlloc, systemUse
$EJECT

;    CpAllocate: PROCEDURE (size, pError) PTR CLEAN;
;        DCL size WORD;
;        DCL pError PTR;
;
;    This is the user's version of allocate.  It will allocate the segment on
;    behalf of the current pid

pError EQU DWORD PTR [BP+6]          ; second param
siz    EQU  WORD PTR [BP+10]         ; first param

CpAllocate PROC FAR
    PUSH BP
    MOV  BP, SP

    MOV  AX, SEG OsCurrentPid
    MOV  ES, AX
    MOV  BX, OFFSET OsCurrentPid     ; OsCurrentPid
    PUSH WORD PTR ES:[BX]

    PUSH siz                         ; size

    LES  BX, pError
    PUSH ES                          ; pError
    PUSH BX

    CALL IntAllocate

    POP BP
    RET 6
CpAllocate ENDP

PURGE pError, siz
$EJECT

;    CpFreeTaskMem: PROCEDURE (pid) CLEAN;
;        DCL pid PidType;
;
;    This will search the allocate queue for any blocks
;    that have been allocated on behalf of this pid and free them.

pid EQU WORD PTR [BP+8]              ; first param

; let DS be curScbSegc

CpFreeTaskMem PROC FAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    CALL EnterMemMgr

    MOV  DS, CS:DataFrame
    MOV  BX, OFFSET osAllocMemQ
    MOV  DS, DS:[BX].headOfQ

OsFtmTopOfLoop:
    MOV  AX, DS
    CMP  AX, nullWord                ; DO WHILE (curScbSeg <> nullWord)
    JE   OsFtmDone

                                
;;;    PUSH DS                          ;     curScbSeg
;;;    CALL CheckCheckSum               ;     verify checksum

    MOV  AX, DS:next
    PUSH AX                          ;     save next element

    MOV  AX, DS:mmcbPid
    CMP  AX, pid                     ;     IF curScb.pid = pid THEN DO;
    JNE  OsFtmNotEqual

    CALL AtOsAllocMemQ               ;         @OsAllocMemQ
    PUSH DS                          ;         curScbSeg
    CALL OsRemoveFromQ

    PUSH DS                          ;         curScbSeg
    CALL AddToFreeChain

OsFtmNotEqual:
    POP  DS                          ;     Get next segment from previous push
    JMP  SHORT OsFtmTopOfLoop

OsFtmDone:
    CALL LeaveMemMgr

    POP  BP
    POP  DS
    RET  2
CpFreeTaskMem ENDP

PURGE pid
$EJECT

;    CpGetMemStatus: PROCEDURE (pid, pMemStatus, pError) CLEAN;
;        DCL pid PidType;
;        DCL (pMemStatus, pError) PTR;
;
;    This will return status information about the memory manager.
;    If pid is null then information is about all processes, else its about
;    that particular process.

pError       EQU DWORD PTR [BP+8]      ; third param
pMemStatus   EQU DWORD PTR [BP+12]     ; second param
pid          EQU  WORD PTR [BP+16]     ; first param

qToUse       EQU DWORD PTR [BP-4]      ; which q
qToUseSeg    EQU  WORD PTR [BP-2]
qToUseOff    EQU  WORD PTR [BP-4]
pStatus      EQU DWORD PTR [BP-8]      ; which part of status
pStatusSeg   EQU  WORD PTR [BP-6]
pStatusOff   EQU  WORD PTR [BP-8]
count        EQU  WORD PTR [BP-10]     ; counter
tempSize     EQU DWORD PTR [BP-14]     ; temp 32 #
tempSizeHigh EQU  WORD PTR [BP-12]
tempSizeLow  EQU  WORD PTR [BP-14]

; let DS be curScbSeg

CpGetMemStatus PROC FAR
    PUSH DS
    PUSH BP
    MOV  BP, SP
    SUB  SP, 14                      ; many local vars
    CALL EnterMemMgr

    LDS  BX, pError
    MOV  WORD PTR DS:[BX], eOK       ; error := eOK

    MOV  AL, 0
    LES  DI, pMemStatus
    MOV  CX, SIZE MemStatusType      ; set status to zeroes
    CLD
    REP  STOSB

    LDS  BX, pMemStatus
    MOV  pStatusSeg, DS              ; initialize status pointer
    MOV  pStatusOff, BX

    MOV  AX, CS:DataFrame
    MOV  qToUseSeg, AX
    MOV  AX, OFFSET OsFreeMemQ       ; first use freeQ
    MOV  qToUseOff, AX

    MOV  count, 2                    ; loop twice

OsGetTopLoop1:
    LDS  BX, qToUse
    MOV  DS, DS:[BX].headOfQ

OsGetTopLoop2:
    MOV  AX, DS
    CMP  AX, nullWord                ; DO WHILE (curScbSeg <> nullWord);
    JNE  OsGet05
    JMP  SHORT OsGetLoop2

OsGet05:
;;;    PUSH DS                          ;   curScbSeg
;;;    CALL CheckCheckSum               ;   verify checksum
    
    CMP  count, 1                    ;   IF second time THEN DO;
    JNZ  OsGet07

    MOV  AX, pid
    CMP  AX, nullWord                ;      IF (pid = nullWord) OR
    JZ   OsGet07

    CMP  AX, DS:mmcbPid              ;         (pid = cur.pid)
    JNZ  OsGetNext                   ;           THEN process this one

OsGet07:
    LES  BX, pStatus

    INC  ES:[BX].freeBlocks          ;   memStatus.freeBlocks += 1;

    MOV  AX, DS:mmcbNumBlk
    MOV  DX, 0
    MOV  CX, 16                      ;   tempSize := DOUBLE(curScb.numBlk) * 16
    MOV  DI, 0
    CALL LQ_DWORD_MUL
    MOV  tempSizeLow, AX
    MOV  tempSizeHigh, DX

    LES  BX, pStatus
    MOV  CX, ES:[BX+freeBytesLow]
    MOV  DI, ES:[BX+freeBytesHigh]
    ADD  CX, AX
    ADC  DI, DX                      ;   status.freeBytes += tempSize
    MOV  ES:[BX+freeBytesLow], CX
    MOV  ES:[BX+freeBytesHigh], DI

    AND  DX, DX                      ;   IF tempSize > 65536 THEN DO;
    LES  BX, pStatus
    JZ   OsGetLessThanBigNum

    MOV  ES:[BX].largestFree, nullWord;      status.largestFree = 65535
    JMP  SHORT OsGetNext

OsGetLessThanBigNum:                 ;   ELSE
    MOV  AX, tempSizeLow             ;       IF status.largestFree < tempsize THEN DO
    CMP  AX, ES:[BX].largestFree
    JB   OsGetNext

    MOV  ES:[BX].largestFree, AX     ;           status.largestFree := tempSize

OsGetNext:
    MOV  DS, DS:next
    JMP  SHORT OsGetTopLoop2

OsGetLoop2:

OsGetLoop1:
    MOV  AX, OFFSET OsAllocMemQ      ; now use alloc q
    MOV  qToUseOff, AX

    MOV  AX, allocBytesOffset
    ADD  pStatusOff, AX              ; now pStatus points to .allocBytes

    DEC  count
    JZ   OsGetDone
    JMP  SHORT OsGetTopLoop1

OsGetDone:
    CALL LeaveMemMgr
    MOV  SP, BP
    POP  BP
    POP  DS
    RET  10
CpGetMemStatus ENDP

PURGE pError, pMemStatus, pid, qToUse, qToUseSeg, qToUseOff
PURGE pStatus, pStatusSeg, pStatusOff, count
PURGE tempSize, tempSizeHigh, tempSizeLow


CODE ENDS

    END
